% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNnetworkfamily-class.R
\docType{data}
\name{PLNnetworkfamily}
\alias{PLNnetworkfamily}
\title{An R6 Class to represent a collection of PLNnetworkfit}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
PLNnetworkfamily
}
\description{
The function \code{\link{PLNnetwork}} produces an instance of this class.

This class comes with a set of methods, some of them being useful for the user:
See the documentation for \code{\link[=getBestModel.PLNnetworkfamily]{getBestModel}},
\code{\link[=getModel.PLNnetworkfamily]{getModel}} and  \code{\link[=plot.PLNnetworkfamily]{plot}}.
}
\section{Fields}{

\describe{
\item{\code{responses}}{the matrix of responses common to every models}

\item{\code{covariates}}{the matrix of covariates common to every models}

\item{\code{offsets}}{the matrix of offsets common to every models}

\item{\code{penalties}}{the sparsity level of the network in the successively fitted models}

\item{\code{models}}{a list of \code{\link[=PLNnetworkfit]{PLNnetworkfit}} object, one per penalty.}

\item{\code{inception}}{a \code{\link[=PLNfit]{PLNfit}} object, obtained when no sparsifying penalty is applied.}

\item{\code{criteria}}{a data frame with the values of some criteria (variational lower bound J, BIC, ICL and R2) for the different models.}
}}

\examples{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
fits <- PLNnetwork(Abundance ~ 1, data = trichoptera)
class(fits)
}
\seealso{
The function \code{\link{PLNnetwork}}, the class \code{\link[=PLNnetworkfit]{PLNnetworkfit}}
}
\keyword{datasets}
