% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLMIXfunctions.R
\name{freq_to_unit}
\alias{freq_to_unit}
\title{Individual rankings/orderings from the frequency distribution}
\usage{
freq_to_unit(freq_distr)
}
\arguments{
\item{freq_distr}{Numeric matrix of the observed sequences with the corresponding frequencies indicated in the last \eqn{(K+1)}-th column.}
}
\value{
Numeric \eqn{N}\eqn{\times}{x}\eqn{K} data matrix of observed individual sequences.
}
\description{
Construct the dataset of individual rankings/orderings from the frequency distribution of the observed sequences.
}
\examples{

library(PLMIX)
library(combinat)
K <- 4
permutation_matrix <- t(matrix(unlist(permn(x=K)),nrow=K,ncol=factorial(K)))
aggregate_data <- cbind(permutation_matrix,sample(factorial(K)))
aggregate_data

freq_to_unit(freq_distr=aggregate_data)
}
\author{
Cristina Mollica and Luca Tardella
}

