% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strip_curves.R
\name{strip_curves}
\alias{strip_curves}
\title{basic curve stripping to get initial estimates}
\usage{
strip_curves(.time, .dv, dose, number_terminal_points, oral = FALSE,
  round = 2)
}
\arguments{
\item{.time}{column for time}

\item{.dv}{column for DV (concentration) values}

\item{dose}{Dose value or column}

\item{number_terminal_points}{number of points in terminal phase}

\item{oral}{whether data is oral (instead of IV)}

\item{round}{number of decimals to round, default to 2}
}
\description{
basic curve stripping to get initial estimates
}
\details{
for oral stripping, if multiple cmax values found per ID, will use the first
}
\examples{
\dontrun{
strip_curves(df$TIME, df$DV, dose =1000, 5, oral=TRUE)
df \%>\% group_by(ID) \%>\% do(data.frame(strip_curves(.$TIME, .$DV, 1000, 5, TRUE)))
}
}
