% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readers.R
\name{read_phx}
\alias{read_phx}
\title{to more easily read data with a 2nd row with units common to phx data}
\usage{
read_phx(data, skip = 0, header = TRUE, sep = "auto",
  stringsAsFactors = FALSE, has_units = FALSE, fread = TRUE,
  data.table = FALSE, ...)
}
\arguments{
\item{data}{the name of the csv}

\item{skip}{rows to skip before header row}

\item{header}{logical value indicating whether the file contains the names of variables
as it's first line}

\item{sep}{field separator character. With fread defaults to 'auto', else defaults
to ","}

\item{stringsAsFactors}{logical value whether to include string columns as factors}

\item{has_units}{logical value whether has a units row below the header (eg phx nlme data)}

\item{fread}{logical value. Use fread from data.table for much faster reading}

\item{data.table}{logical value. When using fread, whether to return 
data.table (TRUE) or data.frame (FALSE)}

\item{...}{additional arguments to read.csv functions}
}
\value{
data frame of read-in csv
}
\description{
to more easily read data with a 2nd row with units common to phx data
}
\details{
helpful function to handle situations where the second row is a units row
as often seen with phoenix-style datasets
}
\examples{
\dontrun{
read_phx("example.csv")
read_phx("example.csv", skip = 1) # will ignore 1st line, good for comment lines
}
}
