% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_classes.R
\docType{class}
\name{data.series-class}
\alias{data.series-class}
\alias{show,data.series-method}
\title{List of dataset objects}
\usage{
\S4method{show}{data.series}(object)
}
\arguments{
\item{object}{an object of class \code{data.series}}
}
\description{
The class \code{data.series} is the blueprint of \code{S4} objects that
store a list of \code{dataset} objects.
}
\section{Slots}{

\describe{
\item{\code{series}}{(\code{numeric}) returns the number of \code{dataset} objects stored.}

\item{\code{days}}{(\code{numeric}) returns the length of the simulated data in days
common to all \code{dataset} objects stored. The default value is \code{60}.}

\item{\code{model}}{(\code{character}) returns a character string, either \code{'MPIN'} or
\code{'adjPIN'}.}

\item{\code{layers}}{(\code{numeric})  returns the number of information layers in
all \code{dataset} objects stored. It takes the value \code{1} for the adjusted PIN
model, i.e. when \code{model} takes the value \code{'adjPIN'}.}

\item{\code{datasets}}{(\code{list}) returns the list of the \code{dataset} objects stored.}

\item{\code{restrictions}}{(\code{list}) returns a binary list that contains the set of
parameter restrictions on the original AdjPIN model in the estimated AdjPIN
model. The restrictions are imposed equality constraints on model parameters.
If the value of the parameter  \code{restricted} is the empty list \code{(list())},
then the model has no restrictions, and the estimated model is the
unrestricted, i.e., the original AdjPIN model. If not empty, the list
contains one or multiple of the following four elements
\verb{\{theta, mu, eps, d\}}. For instance, If \code{theta} is set to \code{TRUE},
then the estimated model has assumed the equality of the probability of
liquidity shocks in no-information, and information days, i.e.,
\thetaB\code{=}\thetaS. If any of the remaining rate elements
\verb{\{mu, eps, d\}} is equal to \code{TRUE}, (say  \code{mu=TRUE}), then the
estimated model imposed equality of the concerned parameter on the buy
side, and on the sell side (\mub\code{=}\mus). If more than one element is
equal to \code{TRUE},  then the restrictions are combined. For instance,
if  the slot \code{restrictions} contains \code{list(theta=TRUE, eps=TRUE, d=TRUE)},
then the estimated AdjPIN model has three restrictions \thetaB\code{=}\thetaS,
\eb\code{=}\es, and \Db\code{=}\Ds, i.e., it has been estimated with just \code{7}
parameters, in comparison to \code{10} in the original unrestricted model.
\verb{[i]} This slot only concerns datasets generated by the function
\code{generatedata_adjpin()}.}

\item{\code{warnings}}{(\code{numeric}) returns numbers referring to the warning errors
caused by a conflict between the different arguments used to call the
function \code{generatedata_mpin()}.}

\item{\code{runningtime}}{(\code{numeric}) returns the running time of the data
simulation in seconds.}
}}

