\name{pintsc.p}
\alias{pintsc.p}
\title{size-controlled phenotypic integration index significance test}

\description{Estimates p-values for the size-controlled phenotypic integration index by generating a null distribution based on product–moment correlations.}
\usage{pintsc.p(traits,control=NA,n.replicates=1000,N.Pearson=15,plot="Results",tails=1)}
\arguments{
  \item{traits}{a dataframe or a matrix object containing traits as columns and individuals as rows}
  \item{control}{a vector containing the variable to control by size.}
  \item{n.replicates}{a numeric, number of randomizations to estimate the null distribution (1000 by default)}
  \item{N.Pearson}{a numeric (>2) to shape the distribution probability to sample the correlation matrix. See  Details.}
  \item{plot}{a string. Possible values are "Results" or "R" to display the simulated null distribution and the observed value as a histogram; and "Pearson.distribution" or "P" to check the distribution generated by the N.Pearson parameter to produce the correlation matrix. Any other value will produce no plot.}
  \item{tails}{possible values are 1 and 2 to set the test for one or two tails. By default is set to 1, because values of integration are expected to be higher in the real than in the simulated dataset.}

	}

\details{This function generates a set of theoretical correlation matrices, with as many rows and columns as the number of variables contained in 'traits'. Values in this matrix are randomly drawn using a Pearson product moment correlation coefficient distribution (as implemented in the SuppDists package). The distribution is shaped by the N.Pearson value as follows: 

N.Pearson = 3 increases frequency for extreme values (that is -1 and +1).

N.Pearson = 4 generates a uniform distribution (similar probability for all values).

N.Pearson > 5 increases frequency for central values (that is, 0).

The option plot="Pearson.distribution" or plot="P" displays the distribution used to generate the theoretical correlation matrices. This plot produces an histogram with 100,000 observations taken from the distribution shaped by the N.Pearson value.
}

\value{ A list with the following elements:
\item{Simulated.cor}{The simulated theoretical correlation matrices.}
\item{Simulated.int}{The phenotypic integration indices estimated on the simulated matrices.}
\item{Simulated.Range}{The range (minimum-maximum) of phenotypic integration indices estimated on the simulated matrices.}
\item{Simulated.Mean}{The mean of phenotypic integration indices estimated on the simulated matrices.}
\item{Real.int}{The phenotypic integration indices estimated on the real dataset.}
\item{Summary}{A data frame containing the integration indices (as rows) for the real and simulated dataset and the p-value (as columns)}

}
\references{
Harder, L.D. 2009. Questions about floral (dis)integration. New Phytologist 183:247–248. 

Ordano, M., Fornoni, J., Boege, K. & Domínguez, C.A. 2008. The adaptive value of phenotypic floral integration. New Phytologist 179:1183–1192.

Wagner, G.P. 1984. On the eigenvalue distribution of genetic and phenotypic dispersion matrices: evidence for a non-random organization of quantitative character variation. Journal of Mathematical Biology 21:77–95.
}
\author{A.J. Muñoz-Pajares, R. Torices}

\seealso{\code{\link{pintsc}}, \code{\link{pintsc.boot}}, \code{\link{pintsc.jack}}}

\examples{

data(tussilago)

# Using a uniform distribution to generate the correlation matrices:

## A) Showing uniform distribution
unif1<-pintsc.p(traits=tussilago[,1:5], control=tussilago[,6],
n.replicates=1000, N.Pearson=4, plot="P")

## B) Showing the resulting null distribution and the real value (red line)
unif2<-pintsc.p(traits=tussilago[,1:5], control=tussilago[,6],
n.replicates=1000, N.Pearson=4, plot="R")

# Using a non-uniform distribution to generate the correlation matrices:

dev.new()
## A) Showing the Pearson product moment correlation coefficient distribution
prmo1<-pintsc.p(traits=tussilago[,1:5], control=tussilago[,6],
n.replicates=1000, N.Pearson=15, plot="P")

## B) Showing the resulting null distribution and the real value (red line)
prmo2<-pintsc.p(traits=tussilago[,1:5], control=tussilago[,6],
n.replicates=1000, N.Pearson=15, plot="R")

# Comparing the uniform and the non-uniform distributions
# as in Harder New Phytologist (2009) 183: 247–248

vari<-2 #variable to plot (INT.c)
toplot1<-unif2$Simulated.int[vari,]
toplot2<-prmo2$Simulated.int[vari,]
HIST<-hist(as.matrix(toplot2),plot=FALSE)
MaxY<-max(HIST$density)

Max<-max(toplot1,toplot2)
Min<-min(HIST$mids)
 plot(c(1,2),xlim=c((Min-0.05*Max),(Max+0.05*Max)),ylim=c(0,(MaxY+0.05*MaxY)),
type="n",ylab="Density",xlab="Maximum integration (percentage)")

 hist(as.matrix(toplot1),add=TRUE,freq=FALSE,breaks=28)
 hist(as.matrix(toplot2),add=TRUE,freq=FALSE,col="grey",breaks=18)
# And the real value as a red line:
abline(v=prmo1$Real[vari],lty=2, col="red")

}
