% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.ps.R
\name{predict.ps}
\alias{predict.ps}
\title{Predict Method for Penalized B-splines objects}
\usage{
\method{predict}{ps}(object, Xnew, ...)
}
\arguments{
\item{object}{An object of class "ps".}

\item{Xnew}{New covariate matrix for prediction, should be dense, centred.}

\item{...}{Not applicable}
}
\value{
Predicted values.
}
\description{
Predicted values based on objects of class "ps".
}
\examples{
library(fda)
betaind = 1
snr  = 2
nsim = 1
n    = 50
p    = 21
Y = array(NA,c(n,nsim))
X = array(NA,c(n,p,nsim))
domain = c(0,1)

M = 20
d = 3
alpha = 10^(-(10:3))


for(itersim in 1:nsim)
{
dat = ngr.data.generator.bsplines(n=n,nknots=64,norder=4,p=p,domain=domain,snr=snr,betaind=betaind)
Y[,itersim]  = dat$Y
X[,,itersim] = dat$X
}

psfit = PenS(Y=Y[1:n,1],X=(X[1:n,,1]), alpha=alpha, M=M, d=d, domain=domain)

predict(psfit,X[1:n,,1])

}
