% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06_MODEL_CV_BOOTS.R
\name{kfold.vld}
\alias{kfold.vld}
\title{K-fold model cross-validation}
\usage{
kfold.vld(model, k = 10, seed = 1984)
}
\arguments{
\item{model}{Model in use, an object of class inheriting from \code{"glm"}}

\item{k}{Number of folds. If \code{k} is equal or greater than the number of observations of
modeling data frame, then validation procedure is equivalent to leave one out cross-validation (LOOCV)
method. For LOOCV, AUC is not calculated. Default is set to 10.}

\item{seed}{Random seed needed for ensuring the result reproducibility. Default is 1984.}
}
\value{
The command \code{kfold.vld} returns a list of two objects.\cr
The first object (\code{iter}), returns iteration performance metrics.\cr
The second object (\code{summary}), is the data frame of iterations averages of performance metrics.
}
\description{
\code{kfold.vld} performs k-fold model cross-validation.
The main goal of this procedure is to generate main model performance metrics such as absolute mean
square error, root mean square error or area under curve (AUC) based on resampling method.
}
\examples{
suppressMessages(library(PDtoolkit))
data(loans)
#run stepFWD
res <- stepFWD(start.model = Creditability ~ 1, 
	   coding = "WoE",
	   db = loans)
#check output elements
names(res)
#extract the final model
final.model <- res$model
#print coefficients
summary(final.model)$coefficients
#print head of coded development data
head(res$dev.db)
#calculate AUC
auc.model(predictions = predict(final.model, type = "response", newdata = res$dev.db),
    observed = res$dev.db$Creditability)
kfold.vld(model = final.model, k = 10, seed = 1984)
}
