% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_UNIVARIATE_ANALYSIS.R
\name{imp.sc}
\alias{imp.sc}
\title{Imputation methods for special cases}
\usage{
imp.sc(
  db,
  sc.all = c(NA, NaN, Inf),
  sc.replace = c(NA, NaN, Inf),
  method.num = "automatic",
  p.val = 0.05
)
}
\arguments{
\item{db}{Data frame of risk factors supplied for imputation.}

\item{sc.all}{Vector of all special case elements. Default values are \code{c(NA, NaN, Inf)}.}

\item{sc.replace}{Vector of special case element to be replaced. Default values are \code{c(NA, NaN, Inf)}.}

\item{method.num}{Imputation method for numeric risk factors. Available options are: \cr
\code{"automatic", "mean", "median", "zero"}.}

\item{p.val}{Significance level of p-value for Pearson normality test. Applicable only if \code{method.num} is
\code{automatic}.}
}
\value{
This function returns list of two data frames. The first data frame contains analyzed risk factors with
imputed values for special cases, while the second data frame presents the imputation report.
Using the imputation report, for each risk factor, user can inspect imputed info (\code{info}),
imputation method (\code{imputation.method}), imputed value (\code{imputed.value}),
number of imputed observations (\code{imputation.num}) and imputed mode
(\code{imputed.mode} - applicable only for categorical risk factors) for each risk factor.
}
\description{
\code{imp.sc} imputes value for special cases.
}
\examples{
suppressMessages(library(PDtoolkit))
data(gcd)
gcd$age[1:20] <- NA
gcd$age.bin <- ndr.bin(x = gcd$age, y = gcd$qual, sc.method = "separately", y.type = "bina")[[2]]
gcd$dummy1 <- NA
#select risk factors for which we want to impute missing values (NA)
db.imp <- gcd[, c("age", "age.bin", "dummy1")]
colSums(is.na(db.imp))
imput.res <- imp.sc(db = db.imp, 
	      method.num = "automatic",
	      p.val = 0.05)
#analyzed risk factors with imputed values
head(imput.res[[1]])
#imputation report
imput.res[[2]]
}
