% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCM.R
\name{PCMPresentCoordinates}
\alias{PCMPresentCoordinates}
\title{Determine which traits are present (active) on each node of the tree}
\usage{
PCMPresentCoordinates(X, tree, metaI)
}
\arguments{
\item{X}{numeric k x N matrix of observed values, with possible NA entries. The
columns in X are in the order of tree$tip.label}

\item{tree}{a phylo object}

\item{metaI}{The result of calling PCMInfo.}
}
\value{
a k x M logical matrix. The function fails in case when all traits are NAs for some of the tips.
In that case an error message is issued
"PCMPresentCoordinates:: Some tips have 0 present coordinates. Consider
removing these tips.".
}
\description{
For every node (root, internal or tip) in tree, build a logical
vector of length k with TRUE values for every present coordinate. Non-present
coordinates arize from NA-values in the trait data. These can occur in two cases:
\describe{
\item{Missing measurements for some traits at some tips:}{the present coordinates
are FALSE for the corresponding tip and trait, but are full for all traits
at all internal and root nodes.}
\item{non-existent traits for some species:}{the FALSE present coordinates
propagate towards the parent
nodes - an internal or root node will have a present coordinate set to FALSE
for a given trait, if all of its descendants have this coordinate set to FALSE.}
}
These two cases have different effect on the likelihood calculation: missing
measurements (NA) are integrated out at the parent nodes; while non-existent
traits (NaN) are treated as reduced dimensionality of the vector at the
parent node.
}
\seealso{
\code{\link{PCMLik}}
}
