% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCMTree.R
\name{PCMTreeDtNodes}
\alias{PCMTreeDtNodes}
\title{A data.table with time, part and regime information for the nodes in a tree}
\usage{
PCMTreeDtNodes(tree)
}
\arguments{
\item{tree}{a phylo object with node-labels and parts}
}
\value{
a data.table with a row for each node in tree and columns as follows:
\itemize{
\item{startNode }{the starting node of each edge or NA_integer_ for the root}
\item{endNode }{the end node of each edge or the root id for the root}
\item{startNodeLab }{the character label for the startNode}
\item{endNodeLab }{the character label for endNode}
\item{startTime }{the time (distance from the root node) for the startNode or
 NA_real_ for the root node}
\item{endTime }{the time (distance from the root node) for the endNode or
 NA_real_ for the root node}
\item{part }{the part to which the edge belongs, i.e. the part of the
 endNode}
\item{regime }{the regime to which the edge belongs, i.e. the regime of the
 part of the endNode}}
}
\description{
A data.table with time, part and regime information for the nodes in a tree
}
\examples{
PCMTreeDtNodes(PCMBaseTestObjects$tree.ab)
}
