% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCM.R
\name{PCMLikTrace}
\alias{PCMLikTrace}
\title{Tracing the log-likelihood calculation of a model over each node of the tree}
\usage{
PCMLikTrace(X, tree, model, SE = matrix(0, PCMNumTraits(model),
  PCMTreeNumTips(tree)), metaI = PCMInfo(X = X, tree = tree, model =
  model, SE = SE, verbose = verbose), log = TRUE, verbose = FALSE)
}
\arguments{
\item{X}{a \code{k x N} numerical matrix with possible \code{NA} and \code{NaN} entries. Each
column of X contains the measured trait values for one species (tip in tree).
Missing values can be either not-available (\code{NA}) or not existing (\code{NaN}).
These two values have are treated differently when calculating
likelihoods: see \code{\link{PCMPresentCoordinates}}.}

\item{tree}{a phylo object with N tips.}

\item{model}{an S3 object specifying both, the model type (class, e.g. "OU") as
well as the concrete model parameter values at which the likelihood is to be
calculated (see also Details).}

\item{SE}{a k x N matrix specifying the standard error for each measurement in
X. Alternatively, a k x k x N cube specifying an upper triangular k x k
factor of the variance covariance matrix for the measurement error
for each node i=1, ..., N.
Default: \code{matrix(0.0, PCMNumTraits(model), PCMTreeNumTips(tree))}.}

\item{metaI}{a list returned from a call to \code{PCMInfo(X, tree, model, SE)},
containing meta-data such as N, M and k. Alternatively, this can be a
function object that returns such a list, e.g. the function\code{PCMInfo}
or the function \code{PCMInfoCpp} from the \code{PCMBaseCpp} package.}

\item{log}{logical indicating whether a log-likelehood should be calculated. Default
is TRUE.}

\item{verbose}{logical indicating if some debug-messages should printed.}
}
\value{
The returned object will, in general, depend on the type of model and
the algorithm used for likelihood calculation. For a G_LInv model and
pruning-wise likelihood calculation, the returned object will be a data.table
with columns corresponding to the node-state variables, e.g. the quadratic
polynomial coefficients associated with each node in the tree.
}
\description{
This is an S3 generic function providing tracing information
for the likelihood calculation for a given tree, data and model parameters.
Useful for illustration or for debugging purpose.
}
\seealso{
\code{\link{PCMInfo}} \code{\link{PCMAbCdEf}} \code{\link{PCMLmr}} \code{\link{PCMSim}} \code{\link{PCMCond}} \code{\link{PCMParseErrorMessage}}
}
