% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHourlyLevel.R
\name{plotHourlyLevel}
\alias{plotHourlyLevel}
\title{Plot Hourly Sound Level}
\usage{
plotHourlyLevel(
  x,
  title = NULL,
  units = NULL,
  scale = c("log", "linear"),
  freqMin = NULL,
  toTz = "UTC",
  cmap = viridis_pal()(25)
)
}
\arguments{
\item{x}{a dataframe with columns \code{UTC}, \code{frequency}, and
\code{value}}

\item{title}{title for the plot. If \code{NULL} (default) it will use the
first value in the \code{type} column of \code{x} (if present)}

\item{units}{name of units for plot labeling, default is taken from
common soundscape units}

\item{scale}{one of \code{'log'} or \code{'linear'} for the scale of
the frequency axis}

\item{freqMin}{minimum frequency for the plot range, if desired to be different
than the minimum frequency of the data}

\item{toTz}{timezone to use for the time axis (input data must be UTC).
Specification must be from \link{OlsonNames}}

\item{cmap}{color palette map to use for plot, default is \link[scales]{viridis_pal}}
}
\value{
a ggplot object
}
\description{
Plots a heatmap of summarised sound levels. Y-axis is hour
of the day, X-axis is frequency bin. Plotted values are the median of
the \code{value} column for each hour/frequency pairing across the dataset.
This function is designed to work with sound level outputs with consistent
frequency bins measured across time
}
\examples{
plotHourlyLevel(system.file('extdata/OLSmall.csv', package='PAMscapes'))

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
