% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPolarDetections.R
\name{plotPolarDetections}
\alias{plotPolarDetections}
\title{Plot Detections in a Polar Plot}
\usage{
plotPolarDetections(
  x,
  bin = c("days/month"),
  quantity = c("count", "mean", "effort", "percentEffort", "percentTotal"),
  group = "species",
  facet = NULL,
  effort = NULL,
  title = NULL
)
}
\arguments{
\item{x}{dataframe of data loaded with \link{loadDetectionData}}

\item{bin}{character specification of the radial and circular (angular)
dimensions of the plot in the form "bin1/bin2", where "bin1" is one of
"detection", "hour", or "day", and "bin2" is one of "hour" or "month". "bin1"
is the units of the radial axis, and "bin2" is the unit of the
circular axis. If "bin1" is "detection", then each row is treated as a distinct
instantaneous detection, otherwise calls are binned using
\link{binDetectionData}.}

\item{quantity}{character indicating what type of quantity to plot. "count"
plots total detections, "mean" plots average detections across \code{group}s,
"effort" plots amount of total effort, "percentTotal" plots number of detections
as a percent of total detections, "percentEffort" plots percent of total
effort with detections.}

\item{group}{a vector of name(s) of columns in \code{x} indicating which rows
are distinct from eachother, used for binning data and accounting for effort.
Typically something like "species", "site", or both}

\item{facet}{optional name of column to facet output plot by}

\item{effort}{Not relevant for \code{quantity} "count or "percentTotal", or
\code{bin} with "detection". If not \code{NULL}, a dataframe describing on
effort times to be formatted with \link{formatEffort}. If effort data is not
provided then times with zero detections will not be properly accounted for.
Alternatively, if columns "effortStart" and "effortEnd" are present in
\code{x}, then these values will be used for start and end of effort}

\item{title}{optional title for plot}
}
\value{
a ggplot object
}
\description{
Plots detection data in a polar plot where the
circular (angular) axis is either the hour of day or month of the year
}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
