% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadEnv.R
\name{downloadEnv}
\alias{downloadEnv}
\title{Download Environmental Data}
\usage{
downloadEnv(data, edinfo, fileName = NULL, buffer = c(0, 0, 0))
}
\arguments{
\item{data}{Data containing Longitude, Latitude, and UTC to download matching
environmental data for}

\item{edinfo}{either a edinfo object from \link{getEdinfo} or \link{erddapToEdinfo}
or an ERDDAP dataset ID}

\item{fileName}{name of the file to save downloaded data. If left as the default
\code{NULL}, data will be saved to a temporary folder}

\item{buffer}{numeric vector of the amount to buffer the Longitude, Latitude, and
UTC coordinates by}
}
\value{
if download is successful, invisibly returns the filename. If it fails returns
  \code{FALSE}.

If successful, the file name of downloaded data. If not, returns \code{FALSE}
}
\description{
Downloads environmental data matching the coordinates in a set of data
}
\examples{

data <- data.frame(Latitude = 32, Longitude = -117,
                   UTC = as.POSIXct('2000-01-01 00:00:00', tz='UTC'))
\dontrun{
# not run because download could take time
# download jplMURSST41 dataset
edi <- erddapToEdinfo('jplMURSST41')
ncFile <- downloadEnv(data, edi, 'sstData.nc')

# browse suggested sst datasets, then download
edi <- browseEdinfo(var='sst')
ncFile <- downloadEnv(data, edi, 'sstData.nc')
}


}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
