% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmeVariance.R
\name{lmeVariance}
\alias{lmeVariance}
\title{lmeVariance Function}
\usage{
lmeVariance(
  data_object,
  featureSet,
  fixed_effect_var = NULL,
  meanThreshold = NULL,
  selectedFeatures = NULL,
  NA_to_zero = FALSE,
  cl = 2,
  lmer_control = FALSE,
  fileName = NULL,
  filePATH = NULL
)
}
\arguments{
\item{data_object}{Input \emph{PALMO} S4 object. It contains annotation
information and expression data from Bulk or single cell data.}

\item{featureSet}{Variance analysis carried out for the feature set provided
such as c('PTID', 'Time', 'Sex')}

\item{fixed_effect_var}{Fixed effect variables. In linear mixed model
fixed_effect_var included as fixed effect variables and variance contribution
obtained by adding them as random variables}

\item{meanThreshold}{Average expression threshold to filter lowly expressed
genes/features Default is 0}

\item{selectedFeatures}{User-defined gene/feature list}

\item{NA_to_zero}{Convert NAs to zero. Default FALSE}

\item{cl}{Number of clusters. Use nCores-1 to run parallel. Default 2}

\item{lmer_control}{control structures for mixed model fitting. Default
optimizer is "bobyqa". Reduces the run time for large data significantly.}

\item{fileName}{User-defined file name, Default outputFile}

\item{filePATH}{User-defined output directory \emph{PATH} Default, current
directory}
}
\value{
PALMO object with variance lmem_res dataframe
}
\description{
This function allows you to calculate inter-donor variation between
participants over longitudinal timepoints. It uses linear mixed model to
calculate variance contribution from each given feature list.
}
\examples{
\dontrun{
palmo_obj=lmeVariance(data_object=palmo_obj,
featureSet=c('PTID','Time','Sex'))
}
}
\keyword{lmeVariance}
