% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genecircosPlot.R
\name{genecircosPlot}
\alias{genecircosPlot}
\title{genecircosPlot Function}
\usage{
genecircosPlot(
  data = NULL,
  data_object = NULL,
  geneList,
  group_position = 1,
  group_oi = NULL,
  titleName = "",
  colorThreshold = 10,
  colorMax = NULL,
  colorscale = FALSE
)
}
\arguments{
\item{data}{Expression matrix or data frame. Rows represents gene/proteins
column represents group:donor (or donor:group)}

\item{data_object}{Input \emph{PALMO} S4 object. It contains annotation
information and expression data from Bulk or single cell data. Rows
represents gene/proteins column represents group:donor (or donor:group)}

\item{geneList}{User-defined genes of interest}

\item{group_position}{Default 1, use 2 when columns are donor:group format}

\item{group_oi}{Optional, User-defined groups to consider and order plot}

\item{titleName}{Title of the plot}

\item{colorThreshold}{User-defined color threshold (same as cvThreshold,
like 5)}

\item{colorMax}{Maximum CV value in heatplot ("max", numeric or NULL)}

\item{colorscale}{Show color scale, TRUE or FALSE (default).}
}
\value{
Circos plots and dataframe
}
\description{
This function allows to Circos Plot for gene list of interest by group
}
\examples{
\dontrun{
genecircosPlot(data_object=palmo_obj, geneList=c('IL32','CCL5','TCF7'))
}
}
\keyword{genecircosPlot}
