% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getExtraneousCladeSubpopulations.R
\name{getExtraneousCladeSubpopulations}
\alias{getExtraneousCladeSubpopulations}
\title{Calculates subpopulations in clades (with two or more subpopulations) that are too far away from other subpopulations (within the same clade) on the constellation plot; these far away subpopulations should be pruned away from the original clades.}
\usage{
getExtraneousCladeSubpopulations(tsneResults, pacman_results,
  threshold_multiplier, max_threshold)
}
\arguments{
\item{tsneResults}{t-SNE output of clade centroids' embedding.}

\item{pacman_results}{PAC-MAN analysis result matrix that contains network annotation, clade IDs and mean (centroid) clade expression levels.}

\item{threshold_multiplier}{how many times the threshold ( (a) spread from center of clade for clades with three or more sample subpopulations and (b) distance from each subpopulation centroid for clades with exactly two subpopulations).}

\item{max_threshold}{the maximum distance (on t-SNE plane) allowed for sample subpopulations to be categorized into the same clade.}
}
\value{
Returns clade subpopulations to be pruned.
}
\description{
Calculates subpopulations in clades (with two or more subpopulations) that are too far away from other subpopulations (within the same clade) on the constellation plot; these far away subpopulations should be pruned away from the original clades.
}

