% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ext2spy.R
\name{ext2spy}
\alias{ext2spy}
\title{Convert Spatial Extent to Polygon}
\usage{
ext2spy(x, crs = "+init=epsg:4326", as_sf = TRUE)
}
\arguments{
\item{x}{An \code{Extent} object, or any object from which an \code{Extent} 
can be extracted, e.g. \code{Raster*}.}

\item{crs}{Coordinate reference system passed to \code{\link{proj4string}}.}

\item{as_sf}{\code{logical}. If \code{TRUE} (default), the returned object is 
of class \code{sf} rather than \code{Spatial*}.}
}
\value{
Depending on 'as_sf', either a \code{sf} or \code{SpatialPolygons} 
object.
}
\description{
Convert a spatial extent to polygons.
}
\examples{
ext = extent(c(25, 70, -5, 30))
ext2spy(ext) # 'sf' (default)
ext2spy(ext, as_sf = FALSE) # 'Spatial*'

}
\seealso{
\code{\link{extent}}.
}
\author{
Florian Detsch
}
