% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.r
\name{importTxtInternal}
\alias{importTxtInternal}
\title{ImportTxtInternal is the parser for importTxt.}
\usage{
importTxtInternal(file, dir = NULL, min = NULL, max = NULL)
}
\arguments{
\item{file}{Filename including path if file is not in current working
directory. File can also be a complete URL. The fileformat
is \code{.txt}.}

\item{dir}{Alternative way to supply the directory where the file is located
(default \code{NULL}).}

\item{min}{Optional argument (\code{numeric}, default \code{NULL})
for minimum rating value in grid.}

\item{max}{Optional argument (\code{numeric}, default \code{NULL})
for maximum rating value in grid.}
}
\value{
List of relevant data.
}
\description{
ImportTxtInternal is the parser for importTxt that constructs an import object. The \code{.txt} file has to be in a fixed
format. There are three mandatory blocks each starting and ending with a predefined tag in uppercase letters. The
first block starts with \code{ELEMENTS} and ends with \verb{END ELEMENTS} and contains one element in each line. The other
mandatory blocks contain the constructs and ratings (see below). In the block containing the constructs the left and
right pole are separated by a colon (:). To define missing values use \code{NA} like in the example below. One optional
block contains the range of the rating scale used defined by two numbers. The order of the blocks is arbitrary. All
text not contained within the blocks is discarded and can thus be used for comments.
}
\details{
\tabular{l}{
\verb{---------------- .txt file -----------------} \cr \cr
\verb{anything not contained within the tags will be discarded} \cr
\code{ELEMENTS}         \cr
\verb{element 1}        \cr
\verb{element 2}        \cr
\verb{element 3}        \cr
\verb{END ELEMENTS}     \cr
\cr
\code{CONSTRUCTS}                 \cr
\verb{left pole 1 : right pole 1} \cr
\verb{left pole 2 : right pole 2} \cr
\verb{left pole 3 : right pole 3} \cr
\verb{left pole 4 : right pole 4} \cr
\verb{END CONSTRUCTS}             \cr
\cr
\code{RATINGS}        \cr
\verb{1 3 2}          \cr
\verb{4 1 1}          \cr
\verb{1 4 4}          \cr
\verb{3 1 1}          \cr
\verb{END RATINGS}    \cr
\cr
\code{RANGE}          \cr
\verb{1 4}            \cr
\verb{END RANGE}      \cr
\verb{---------------- end of file ----------------} \cr
}

Note that the maximum and minimum value has to be defined using the \code{min} and
\code{max} arguments if no \code{RANGE} block is contained in the data file.
Otherwise the scaling range is inferred from the available data and a warning
is issued as the range may be erroneous. This may effect other functions that
depend on knowing the correct range and it is thus strongly recommended to
set the scale range correctly.

Question marks (?) in the ratings are treated as missing data.
}
\examples{
\dontrun{

# supposing that the data file sample.txt is in the current directory
file <- "sample.txt"
imp <- importTxtInternal(file)

# specifying a directory (arbitrary example directory)
dir <- "/Users/markheckmann/data"
imp <- importTxtInternal(file, dir)

# using a full path
imp <- importTxtInternal("/Users/markheckmann/data/sample.txt")
}

}
\keyword{internal}
