% Generated by roxygen2 (4.0.2): do not edit by hand
\name{mxComputeOnce}
\alias{MxComputeOnce-class}
\alias{mxComputeOnce}
\title{Compute something once}
\usage{
mxComputeOnce(from, what = "nothing", how = NULL, ...,
  freeSet = NA_character_, verbose = 0L, .is.bestfit = FALSE)
}
\arguments{
\item{from}{the object to perform the computation (a vector of expectation or fit function names)}

\item{what}{what to compute (default is "nothing")}

\item{how}{to compute it (optional)}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{freeSet}{names of matrices containing free variables}

\item{verbose}{the level of debugging output}

\item{.is.bestfit}{do not use; for backward compatibility}
}
\description{
Some models are optimized for a sparse Hessian. Therefore, it can
be much more efficient to compute the inverse Hessian in
comparison to computing the Hessian and then inverting it.
}
\details{
The information matrix is only valid when parameters are at the
maximum likelihood estimate. The information matrix is returned in
model$output$hessian. You cannot request both the information
matrix and the Hessian. The information matrix is invarient to the
sign of the log likelihood scale whereas the Hessian is not.
Use the \code{how} parameter to specify which approximation to use
(one of "default", "hessian", "sandwich", "bread", and "meat").
}
\examples{
data(demoOneFactor)
factorModel <- mxModel(name ="One Factor",
  mxMatrix(type="Full", nrow=5, ncol=1, free=TRUE, values=0.2, name="A"),
    mxMatrix(type="Symm", nrow=1, ncol=1, free=FALSE, values=1, name="L"),
    mxMatrix(type="Diag", nrow=5, ncol=5, free=TRUE, values=1, name="U"),
    mxAlgebra(expression=A \%*\% L \%*\% t(A) + U, name="R"),
    mxFitFunctionML(),mxExpectationNormal(covariance="R", dimnames=names(demoOneFactor)),
    mxData(observed=cov(demoOneFactor), type="cov", numObs=500),
    mxComputeOnce('fitfunction', 'fit'))
factorModelFit <- mxRun(factorModel)
factorModelFit$output$fit  # 972.15
}

