% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MxCompute.R
\name{mxComputeNumericDeriv}
\alias{mxComputeNumericDeriv}
\alias{MxComputeNumericDeriv-class}
\title{Numerically estimate Hessian using Richardson extrapolation}
\usage{
mxComputeNumericDeriv(freeSet = NA_character_, ...,
  fitfunction = "fitfunction", parallel = TRUE,
  stepSize = imxAutoOptionValue("Gradient step size"), iterations = 4L,
  verbose = 0L, knownHessian = NULL, checkGradient = TRUE,
  hessian = TRUE)
}
\arguments{
\item{freeSet}{names of matrices containing free variables}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{fitfunction}{name of the fitfunction (defaults to 'fitfunction')}

\item{parallel}{whether to evaluate the fitfunction in parallel (defaults to TRUE)}

\item{stepSize}{starting set size (defaults to 0.0001)}

\item{iterations}{number of Richardson extrapolation iterations (defaults to 4L)}

\item{verbose}{integer. Level of run-time diagnostic output. Set to zero to disable}

\item{knownHessian}{an optional matrix of known Hessian entries}

\item{checkGradient}{whether to check the first order convergence criterion (gradient is near zero)}

\item{hessian}{whether to estimate the Hessian. If FALSE then only the gradient is estimated.}
}
\description{
For N free parameters, Richardson extrapolation requires
(iterations * (N^2 + N)) function evaluations.
The implementation is closely based on the numDeriv R package.
}
\details{
In addition to an estimate of the Hessian, forward, central, and
backward estimates of the gradient are made available in this
compute plan's output slot.

When \code{checkGradient=TRUE}, the central difference estimate of
the gradient is used to determine whether the first order
convergence criterion is met. In addition, the forward and
backward difference estimates of the gradient are compared for
symmetry. When sufficient asymmetry is detected, the standard
error is flagged. In the case, profile likelihood confidence
intervals should be used for inference instead of standard errors
(see \code{mxComputeConfidenceInterval}).

If provided, the square matrix \code{knownHessian} should have
dimnames set to the names of some subset of the free
parameters. Entries of the matrix set to NA will be estimated
numerically while entries containing finite values will be copied
to the Hessian result.
}
\examples{
library(OpenMx)
data(demoOneFactor)
factorModel <- mxModel(name ="One Factor",
	mxMatrix(type = "Full", nrow = 5, ncol = 1, free = FALSE, values = .2, name = "A"), 
	mxMatrix(type = "Symm", nrow = 1, ncol = 1, free = FALSE, values = 1 , name = "L"), 
	mxMatrix(type = "Diag", nrow = 5, ncol = 5, free = TRUE , values = 1 , name = "U"), 
	mxAlgebra(A \%*\% L \%*\% t(A) + U, name = "R"),
	mxExpectationNormal(covariance = "R", dimnames = names(demoOneFactor)), 
	mxFitFunctionML(), 
	mxData(cov(demoOneFactor), type = "cov", numObs = 500), 
	mxComputeSequence(
		list(mxComputeNumericDeriv(), mxComputeReportDeriv())
	)
)
factorModelFit <- mxRun(factorModel)
factorModelFit$output$hessian
}
