% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superpixels.R
\name{RGB_to_Lab}
\alias{RGB_to_Lab}
\title{Conversion of RGB to Lab colour type}
\usage{
RGB_to_Lab(input_data)
}
\arguments{
\item{input_data}{a 3-dimensional array (RGB image) where the third dimension is equal to 3}
}
\description{
Conversion of RGB to Lab colour type
}
\details{
Meaning: RGB (Red-Green-Blue) to LAB (Lightness, A-colour-dimension, B-colour-dimension) colour conversion
}
\examples{

library(OpenImageR)

set.seed(1)
array_3d = array(sample(1:255, 675, replace = TRUE), c(15, 15, 3))

res = RGB_to_Lab(array_3d)

}
\references{
https://www.epfl.ch/labs/ivrl/research/snic-superpixels/
}
