% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenDat_KJ.r
\name{GenDat_KJ}
\alias{GenDat_KJ}
\title{Generate Survival Data with unrestricted Follow-Up}
\usage{
GenDat_KJ(shape, S_fixed, x_fixed, rate, tf, t1, n, seed)
}
\arguments{
\item{shape}{shape parameter for WB distributions.}

\item{S_fixed}{survival probability at the fixed time point x_fixed.}

\item{x_fixed}{a fixed time point where the survival probability is known.}

\item{rate}{a constant accrual rate.}

\item{tf}{the follow-up time.}

\item{t1}{the interim analysis time.}

\item{n}{sample size.}

\item{seed}{seed used for the random sample generation.}
}
\value{
Two dataframes: data (the full data for final analysis) and data_t1 (the data for interim analysis), both containing the following 4 variables:\cr
\emph{Entry} time when each patient enters the trial, assumed to be uniform from 0 to ta with ta as the time when enrollment ends.\cr
\emph{time} the time under observation during entire trial (in data) or before t1 (in data_t1) for each patient.\cr
\emph{status} the status indicator of patients (event = 1, censored = 0), which can be different between data and data_t1.\cr
\emph{Total} the sum of \emph{Entry} and \emph{time}.
}
\description{
Generate survival data with restricted follow-up Using Weibull Distribution.
}
\keyword{internal}
