% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canberra.R
\name{canberra}
\alias{canberra}
\title{Compute Canberra Dissimilarity from a Sparse Matrix.}
\usage{
canberra(x, weighted = TRUE, threads = 1)
}
\arguments{
\item{x}{A \link[Matrix]{sparseMatrix}.}

\item{weighted}{A boolean value, to use abundances (\code{weighted = TRUE}) or absence/presence (\code{weighted=FALSE}) (default: TRUE).}

\item{threads}{A wholenumber, the number of threads to use in \link[RcppParallel]{setThreadOptions} (default: 1).}
}
\value{
A column x column \link[stats]{dist} object.
}
\description{
Calculates the Canberra dissimilarity of a \link[Matrix]{sparseMatrix} pairwise for each column.
}
\details{
The Canberra dissimilarity between two samples \eqn{A} and \eqn{B}, each of length \eqn{n}, is defined as:

\eqn{d(A,B) = \frac{1 / NZ} \sum_{i}^n \frac{|A_i - B_i|}{|A_i| + |B_i|}}

where \eqn{A_i} and \eqn{B_i} are the abundances of the \eqn{i}-th feature in sample \eqn{A} and \eqn{B}, respectively. NZ are the number of non-zero entries.
When weighted is set to FALSE, counts are replaced by presence/absence data.
}
\examples{
library("OmicFlow")

metadata_file <- system.file("extdata", "metadata.tsv", package = "OmicFlow")
counts_file <- system.file("extdata", "counts.tsv", package = "OmicFlow")
features_file <- system.file("extdata", "features.tsv", package = "OmicFlow")
tree_file <- system.file("extdata", "tree.newick", package = "OmicFlow")

taxa <- metagenomics$new(
    metaData = metadata_file,
    countData = counts_file,
    featureData = features_file,
    treeData = tree_file
)

taxa$feature_subset(Kingdom == "Bacteria")
taxa$normalize()

canberra(taxa$countData)
}
\references{
Lance, G.N. & Williams, W.T. (1967) Mixed-data classificatory programs. I. Agglomerative systems. Australian Computer Journal, 1(1), 15-20.
}
