% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align.R
\name{align}
\alias{align}
\title{Optimal Transport Alignment}
\usage{
align(data)
}
\arguments{
\item{data}{-- a matrix of horizontally stacked cluster labels. Each column contains cluster labels for all the data points according to one clustering result. The reference clustering result is put in the first column.}
}
\value{
a list of alignment result.
\item{distance}{Wasserstein distances between the reference partition and the others.}
\item{numcls}{the number of clusters for each partition.}
\item{statistics}{average tightness ratio, average coverage ratio, 1-average jaccard distance.}
\item{cap}{cluster alignment and points based (CAP) separability.}
\item{id}{}
\item{cps}{covering point set.}
\item{match}{topological relationship statistics between the reference partition and the others.}
\item{Weight}{weight matrix}
}
\description{
This function aligns an ensemble of partitions with a reference partition by optimal transport.
}
\examples{
data(sim1)
# the number of clusters.
C = 4
# calculate baseline method for comparison.
kcl = kmeans(sim1$X,C)
# align clustering results for convenience of comparison.
compar = align(cbind(sim1$z,kcl$cluster))
}
