% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ConfusionTable.R
\name{plot.ConfusionTable}
\alias{plot.ConfusionTable}
\title{Extended Confusion Table Plot}
\usage{
\method{plot}{ConfusionTable}(
  x = NULL,
  classNames = NULL,
  main = "extended confusion table",
  xlab = "original class labels",
  ylab = "predictions",
  cascLab = "cascade",
  otherLab = "other classes",
  digits = 3,
  ignore = 0,
  casc.colors = c("#f5f5f5", "#8c510a"),
  other.colors = c("#f5f5f5", "#01665e"),
  colSep = "#b2182b",
  las = 1,
  color.key = TRUE,
  cex = 1,
  cex.lab = 1,
  ...
)
}
\arguments{
\item{x}{A ConfusionTable object as it is returned by \code{\link{confusion.table}}-function.}

\item{classNames}{Vector of the original class names. If not given the class number is used instead.}

\item{main}{See \code{\link{plot}}.}

\item{xlab}{A title for the x axis (see \code{\link{plot}}).}

\item{ylab}{A title for the y axis (see \code{\link{plot}}).}

\item{cascLab}{Character string used as header for the cascade part of the extended confusion table.}

\item{otherLab}{Character string used as header for the other class part of the extended confusion table.}

\item{digits}{Integer indicating the number of decimal places to be used (see \code{\link{round}}).}

\item{ignore}{A numeric value between 0 and 1.
All confusion and purity values below this number are not written as string into the corresponding element.}

\item{casc.colors}{A 2-element vector of the color for the minimal and maximal class-wise sensitivity of the first class.
The color palette is calcuated by an interpolation between the 2 given colors.}

\item{other.colors}{A 2-element vector of the color for the minimal and maximal class-wise sensitivity of the second class.
The color palette is calcuated by an interpolation between the 2 given colors.}

\item{colSep}{Color, which is used for the vertical line separating the cascade classes and the other classes.}

\item{las}{See \code{\link{par}}.}

\item{color.key}{Specifies whether a color key is drawn (TRUE) or not (FALSE).}

\item{cex}{See \code{\link{par}}.}

\item{cex.lab}{See \code{\link{par}}.}

\item{...}{Further arguments passed from other methods.}
}
\value{
No return value, called to generate the confusion table plot.
}
\description{
Plots an extended confusion table.
}
\examples{
library(TunePareto)
data(esl)
data <- esl$data
labels <- esl$labels
foldList <- generateCVRuns(labels  = labels,
                          ntimes      = 2,
                          nfold       = 2,
                          leaveOneOut = FALSE,
                          stratified  = TRUE)
genMap <- gen.predictionMap(data, labels, foldList = foldList, 
classifier = tunePareto.svm(), kernel='linear')
# generate Subcascades object
conf.table <- confusion.table(genMap,cascade='0>1>3>4',other.classes = 'all')

plot(conf.table)


}
\seealso{
\code{\link{confusion.table}}, \code{\link{plot.Subcascades}}, \code{\link{plot.Conf}}
}
