% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.Subcascades}
\alias{print.Subcascades}
\title{Prints all details about a Subcascades object.}
\usage{
\method{print}{Subcascades}(x, printSizes = length(x), ...)
}
\arguments{
\item{x}{A Subcascades object generated by \code{\link{subcascades}}.}

\item{printSizes}{Integer specifying how many elements of a Subcascades object should be printed, 
sorted decreasingly after cascade length.}

\item{...}{Further parameters}
}
\description{
Prints all details about a Subcascades object.
}
\details{
Prints all details about a given Subcascades object.
}
\examples{
library(TunePareto)
data(esl)
data = esl$data
labels = esl$labels
foldList = generateCVRuns(labels  = labels,
                          ntimes      = 2,
                          nfold       = 2,
                          leaveOneOut = FALSE,
                          stratified  = TRUE)
predMap = predictionMap(data, labels, foldList = foldList, 
                       classifier = tunePareto.svm(),  kernel='linear')

# use default parameter settings 
# -> returns cascades of all lengths that show a minimal classwise sensitivity >0.
subc = subcascades(predMap)

# print subcascades for the largest 2 sizes
print(subc, printSize=2)
}
