% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsr_fit.R
\name{opsr.fit}
\alias{opsr.fit}
\title{Fitter Function for Ordinal Probit Switching Regression Models}
\usage{
opsr.fit(
  Ws,
  Xs,
  Ys,
  start,
  fixed,
  weights,
  method,
  iterlim,
  printLevel,
  nThreads,
  .useR = FALSE,
  ...
)
}
\arguments{
\item{Ws}{list of matrices with explanatory variables for selection process for each regime.}

\item{Xs}{list of matrices with expalanatory varialbes for outcome process for each regime.}

\item{Ys}{list of vectors with continuous outcomes for each regime.}

\item{start}{a numeric vector with the starting values (passed to \code{\link[maxLik:maxLik]{maxLik::maxLik}}).}

\item{fixed}{parameters to be treated as constants at their \code{start} values. If
present, it is treated as an index vector of \code{start} parameters (passed to \code{\link[maxLik:maxLik]{maxLik::maxLik}}).}

\item{weights}{a vector of weights to be used in the fitting process. Has to
conform with order (\code{w <- weights[order(Z)]}, where Z is the ordinal
outcome).}

\item{method}{maximzation method (passed to \code{\link[maxLik:maxLik]{maxLik::maxLik}}).}

\item{iterlim}{maximum number of iterations (passed to \code{\link[maxLik:maxLik]{maxLik::maxLik}}).}

\item{printLevel}{larger number prints more working information (passed to \code{\link[maxLik:maxLik]{maxLik::maxLik}}).}

\item{nThreads}{number of threads to be used. Do not pass higher number than
number of ordinal outcomes. See also \code{\link{opsr_check_omp}} and \code{\link{opsr_max_threads}}.}

\item{.useR}{if \code{TRUE}, usese \code{\link{loglik_R}}. Go grab a coffe.}

\item{...}{further arguments passed to \code{\link[maxLik:maxLik]{maxLik::maxLik}}.}
}
\value{
object of class \verb{"maxLik" "maxim"}.
}
\description{
This is the basic computing engine called by \code{\link{opsr}} used to fit ordinal
probit switching regression models. Should usually \emph{not} be used directly.
The log-likelihood function is implemented in C++ which yields a considerable
speed-up. Parallel computation is implemented using \code{OpenMP}.
}
\seealso{
\code{\link[maxLik:maxLik]{maxLik::maxLik}}, \code{\link{loglik_cpp}}, \code{\link{opsr}}
}
