\name{size_c.three_way}
\alias{size_c.three_way_cross.model_3_a           }
\alias{size_c.three_way_cross.model_3_axb         }
\alias{size_c.three_way_mixed_ab_in_c.model_5_a   }
\alias{size_c.three_way_mixed_ab_in_c.model_5_axb }
\alias{size_c.three_way_mixed_ab_in_c.model_5_b   }
\alias{size_c.three_way_mixed_ab_in_c.model_6_b   }
\alias{size_c.three_way_mixed_cxbina.model_5_a    }
\alias{size_c.three_way_mixed_cxbina.model_5_b    }
\alias{size_c.three_way_mixed_cxbina.model_7_b    }
\alias{size_c.three_way_nested.model_5_a          }
\alias{size_c.three_way_nested.model_5_b          }
\alias{size_c.three_way_nested.model_7_b          }

\title{
Three-way analysis of variance -- several cross-, nested and mixed  classifications.
}
\description{
Returns the optimal number of levels for .
}
\usage{
size_c.three_way_cross.model_3_a          (alpha, beta, delta, a, b, n, cases)
size_c.three_way_cross.model_3_axb        (alpha, beta, delta, a, b, n, cases)
size_c.three_way_mixed_ab_in_c.model_5_a  (alpha, beta, delta, a, b, n, cases)
size_c.three_way_mixed_ab_in_c.model_5_axb(alpha, beta, delta, a, b, n, cases)
size_c.three_way_mixed_ab_in_c.model_5_b  (alpha, beta, delta, a, b, n, cases)
size_c.three_way_mixed_ab_in_c.model_6_b  (alpha, beta, delta, a, b, n, cases)
size_c.three_way_mixed_cxbina.model_5_a   (alpha, beta, delta, a, b, n, cases)
size_c.three_way_mixed_cxbina.model_5_b   (alpha, beta, delta, a, b, n, cases)
size_c.three_way_mixed_cxbina.model_7_b   (alpha, beta, delta, a, b, n, cases)
size_c.three_way_nested.model_5_a         (alpha, beta, delta, a, b, n, cases)
size_c.three_way_nested.model_5_b         (alpha, beta, delta, a, b, n, cases)
size_c.three_way_nested.model_7_b         (alpha, beta, delta, a, b, n, cases)
}
\arguments{
  \item{alpha}{
Risk of 1st kind
}
  \item{beta}{
Risk of 2nd kind
}
  \item{delta}{
The minimum difference to be detected
}
  \item{a}{
Number of levels of fixed factor A
}
  \item{b}{
Number of levels of fixed factor B
}
  \item{n}{
Number of replications
}
  \item{cases}{
Specifies whether the \code{"maximin"} or \code{"maximin"} sizes are to be determined
}
}
\details{
see chapter 3 in the referenced book
}
\value{
integer, desired size of factor C
}
\references{
Dieter Rasch, Juergen Pilz, L.R. Verdooren, Albrecht Gebhardt: Optimal Experimental Design with R, Chapman and Hall/CRC, 2011
}
\author{
Dieter Rasch, Juergen Pilz, L.R. Verdooren, Albrecht Gebhardt, Minghui Wang
}
\note{
  Better use \code{\link{size.anova}} which allows a cleaner notation.
}

\seealso{
\code{\link{size.anova}}
}
\examples{
size_c.three_way_cross.model_3_a(0.05, 0.1, 0.5, 6, 5, 2, "maximin")
size_c.three_way_cross.model_3_a(0.05, 0.1, 0.5, 6, 5, 2, "minimin")

size_c.three_way_cross.model_3_axb(0.05, 0.1, 0.5, 6, 5, 2, "maximin")
size_c.three_way_cross.model_3_axb(0.05, 0.1, 0.5, 6, 5, 2, "minimin")

size_c.three_way_mixed_ab_in_c.model_5_a(0.05, 0.1, 0.5, 6, 5, 1, "maximin")
size_c.three_way_mixed_ab_in_c.model_5_a(0.05, 0.1, 0.5, 6, 5, 1, "minimin")

size_c.three_way_mixed_ab_in_c.model_5_axb(0.05, 0.1, 0.5, 6, 5, 1, "maximin")
size_c.three_way_mixed_ab_in_c.model_5_axb(0.05, 0.1, 0.5, 6, 5, 1, "minimin")

size_c.three_way_mixed_ab_in_c.model_5_b(0.05, 0.1, 0.5, 6, 5, 1, "maximin")
size_c.three_way_mixed_ab_in_c.model_5_b(0.05, 0.1, 0.5, 6, 5, 1, "minimin")

size_c.three_way_mixed_ab_in_c.model_6_b(0.05, 0.1, 0.5, 6, 5, 1, "maximin")
size_c.three_way_mixed_ab_in_c.model_6_b(0.05, 0.1, 0.5, 6, 5, 1, "minimin")

size_c.three_way_mixed_cxbina.model_5_a(0.05, 0.1, 0.5, 6, 5, 2, "maximin")
size_c.three_way_mixed_cxbina.model_5_a(0.05, 0.1, 0.5, 6, 5, 2, "minimin")

size_c.three_way_mixed_cxbina.model_5_b(0.05, 0.1, 0.5, 6, 5, 2, "maximin")
size_c.three_way_mixed_cxbina.model_5_b(0.05, 0.1, 0.5, 6, 5, 2, "minimin")

size_c.three_way_mixed_cxbina.model_7_b(0.05, 0.1, 0.5, 6, 5, 2, "maximin")
size_c.three_way_mixed_cxbina.model_7_b(0.05, 0.1, 0.5, 6, 5, 2, "minimin")

size_c.three_way_nested.model_5_a(0.05, 0.1, 0.5, 6, 5, 2, "maximin")
size_c.three_way_nested.model_5_a(0.05, 0.1, 0.5, 6, 5, 2, "minimin")

size_c.three_way_nested.model_5_b(0.05, 0.1, 0.5, 6, 5, 2, "maximin")
size_c.three_way_nested.model_5_b(0.05, 0.1, 0.5, 6, 5, 2, "minimin")

size_c.three_way_nested.model_7_b(0.05, 0.1, 0.5, 6, 4, 1, "maximin")
size_c.three_way_nested.model_7_b(0.05, 0.1, 0.5, 6, 4, 1, "minimin")

}
\keyword{ anova }
