% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{outlier.remove}
\alias{outlier.remove}
\title{remove outliers}
\usage{
outlier.remove(x, rg = 3)
}
\arguments{
\item{x}{a numeric data vector.}

\item{rg}{a positive number indicating how the outliers are defined; see
details.}
}
\value{
a list containing the following: \item{x}{a new
data vector with outliers replaced with \eqn{NA}. The original
missing values in the data are preserved.} \item{id}{the locations of the
outliers in the data vector.}
}
\description{
This function removes outliers in the data, which are far from the sample
median.
}
\details{
An outlier is detected if it deviates from the sample median more than
\emph{rg} times interquantile range.
}
\examples{

a=c(1:5,NA,10000)
outlier.remove(a,3)
}
\author{
Yong He, Xinbing Kong, Lorenzo Trapani, Long Yu
}
