% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/online_ODRF.R
\name{online.ODRF}
\alias{online.ODRF}
\title{using new training data to update an existing \code{ODRF}.}
\usage{
\method{online}{ODRF}(obj, X, y, weights = NULL, MaxDepth = Inf, ...)
}
\arguments{
\item{obj}{An object of class \code{ODRF}.}

\item{X}{An new n by d numeric matrix (preferable) or data frame  used to update the object of class \code{ODRF}.}

\item{y}{A new response vector of length n used to update the object of class \code{ODRF}.}

\item{weights}{A vector of non-negative observational weights; fractional weights are allowed (default NULL).}

\item{MaxDepth}{The maximum depth of the tree (default \code{Inf}).}

\item{...}{Optional parameters to be passed to the low level function.}
}
\value{
The same result as \code{ODRF}.
}
\description{
Update existing \code{\link{ODRF}} using new data to improve the model.
}
\examples{
# Classification with Oblique Decision Random Forest
data(seeds)
set.seed(221212)
train <- sample(1:209, 80)
train_data <- data.frame(seeds[train, ])
test_data <- data.frame(seeds[-train, ])
index <- seq(floor(nrow(train_data) / 2))
forest <- ODRF(varieties_of_wheat ~ ., train_data[index, ],
  split = "gini", parallel = FALSE, ntrees = 50
)
online_forest <- online(forest, train_data[-index, -8], train_data[-index, 8])
pred <- predict(online_forest, test_data[, -8])
# classification error
(mean(pred != test_data[, 8]))

# Regression with Oblique Decision Random Forest
\donttest{
data(body_fat)
set.seed(221212)
train <- sample(1:252, 80)
train_data <- data.frame(body_fat[train, ])
test_data <- data.frame(body_fat[-train, ])
index <- seq(floor(nrow(train_data) / 2))
forest <- ODRF(Density ~ ., train_data[index, ],
  split = "mse", parallel = FALSE
)
online_forest <- online(
  forest, train_data[-index, -1],
  train_data[-index, 1]
)
pred <- predict(online_forest, test_data[, -1])
# estimation error
mean((pred - test_data[, 1])^2)
}

}
\seealso{
\code{\link{ODRF}} \code{\link{prune.ODRF}} \code{\link{online.ODT}}
}
\keyword{forest}
\keyword{online}
