% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop_rotation.R
\name{calc_rotation_fraction}
\alias{calc_rotation_fraction}
\title{Calculates the fraction in the crop rotation}
\usage{
calc_rotation_fraction(ID, B_LU_BRP, crop)
}
\arguments{
\item{ID}{(numeric) The ID of the field}

\item{B_LU_BRP}{(numeric) The crop code (gewascode) from the BRP}

\item{crop}{(character) The crop to check for. For relevant crop categories, see details.}
}
\value{
The fraction of specific crop types within the crop rotation sequence. A numeric value.
}
\description{
This function calculates the fraction present in the crop rotation
}
\details{
This function calculates the fraction present in the crop rotation for specific crop categories. 
These categories include "starch", "potato", "sugarbeet", "grass", "mais", "alfalfa","catchcrop","cereal","clover",'nature', rapeseed',"other","rustgewas",and "rustgewasdiep".
}
\examples{
calc_rotation_fraction(ID = rep(1,4), B_LU_BRP = c(265,1910,1935,1033),crop = 'potato')
calc_rotation_fraction(ID = rep(1,4), B_LU_BRP = c(265,1910,1935,1033),crop = 'grass')

}
