% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{bootstrap}
\alias{bootstrap}
\title{bootstrap}
\usage{
bootstrap(estimator, Z, B = 400, blocks = NULL, use_gpu = TRUE)
}
\arguments{
\item{estimator}{a neural estimator}

\item{Z}{either a list of data sets simulated conditionally on the fitted parameters (parametric bootstrap); or a single observed data set containing independent replicates, which will be sampled with replacement \code{B} (non-parametric bootstrap)}

\item{B}{number of non-parametric bootstrap estimates (default 400)}

\item{blocks}{integer vector specifying the blocks in non-parameteric bootstrap (default \code{NULL}). For example, with 5 replicates, the first two corresponding to block 1 and the remaining three corresponding to block 2, \code{blocks} should be \code{c(1,1,2,2,2)}. The bootstrap sampling algorithm aims to produce bootstrap data sets that are of a similar size to \code{Z}, but this can only be achieved exactly if all blocks are equal in length.}

\item{use_gpu}{a boolean indicating whether to use the GPU if it is available (default \code{TRUE})}
}
\value{
p × B matrix, where p is the number of parameters in the model and B is the number of bootstrap samples
}
\description{
Compute bootstrap estimates from a neural estimator
}
\examples{
\dontrun{
library("NeuralEstimators")
library("JuliaConnectoR")

## Observed data: m independent replicates of a N(0, 1) random variable
m = 100
Z = t(rnorm(m))

## Construct an (un-trained) neural point estimator
estimator <- initialise_estimator(1, architecture = "MLP")

## Non-parametric bootstrap
bootstrap(estimator, Z = Z)
bootstrap(estimator, Z = Z, blocks = rep(1:5, each = m/5))
}
}
