% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impact.R
\name{impact}
\alias{impact}
\title{Node Impact}
\usage{
impact(A)
}
\arguments{
\item{A}{An adjacency matrix of network data}
}
\value{
A vector of node impact values for each node in the network
(impact > 0, greater ASPL when node is removed; impact < 0,
lower ASPL when node is removed)
}
\description{
Computes impact measure or how much the average distance in the
network changes with that node removed of each node in a network
(\strong{Please see and cite Kenett et al., 2011})
}
\examples{
# normal set to FALSE for CRAN tests
A <- TMFG(neoOpen, normal = FALSE)$A

nodeimpact <- impact(A)

}
\references{
Cotter, K. N., Christensen, A. P., & Silvia, P. J. (in press).
Understanding inner music: A dimensional approach to musical imagery.
\emph{Psychology of Aesthetics, Creativity, and the Arts}.

Kenett, Y. N., Kenett, D. Y., Ben-Jacob, E., & Faust, M. (2011).
Global and local features of semantic networks: Evidence from the Hebrew mental lexicon.
\emph{PLoS one}, \emph{6}, e23912.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
