% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Extintions.R
\name{CompareExtinctions}
\alias{CompareExtinctions}
\title{Comparison of Null hypothesis with other extinction histories}
\usage{
CompareExtinctions(Nullmodel, Hypothesis)
}
\arguments{
\item{Nullmodel}{an object generated by the RandomExtinctions}

\item{Hypothesis}{Extinction history generated by the Mostconected or ExtinctionOrder
fuction}
}
\value{
a plot comparing the expected value of secondary extinctions originated at random
with the observed extinction history. Also, and a goodness of fit test
showing if there are significant differences between expected value of
secondary extinctions and the observed secondary extinction history.
}
\description{
It compares an object genrated either by the Mostconected or ExtinctionOrder functions
with a null hypothesis generated by the RandomExtinctions function and it tests weather
they are significantly different.
}
\examples{
data("net")
History <- Mostconnected(Network = net)

NullHyp <- RandomExtinctions(Network = net, nsim = 100)

CompareExtinctions(Nullmodel = NullHyp, Hypothesis = History)
}
\author{
Derek Corcoran <derek.corcoran.barrios@gmail.com>

M.Isidora Avila Thieme <msavila@uc.cl>
}
