% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-functions.R
\name{plotMultiBar}
\alias{plotMultiBar}
\title{Plot multiple horizontal bar plots}
\usage{
plotMultiBar(lengths, lengths.lim, cols, bar.width = 1, drawBorders = FALSE,
  main = "", main.line = 1, na.col = "#bdbdbd", yaxt = TRUE,
  plotModuleNames = TRUE, yaxt.line = 0, maxt.line = 2.5, xaxt.line = 0,
  xaxt.tck = -0.025, xlab = "", xlab.line = 2.5, cex.modules = 0.7,
  lwd = 2, dryRun = FALSE)
}
\arguments{
\item{lengths}{a matrix whose columns contain the lengths of each bar for 
the given property (e.g. each column should be a module, or phenotype).}

\item{lengths.lim}{a list of limits for the lengths axes.}

\item{cols}{a matrix of colors for each bar.}

\item{bar.width}{value between 0 and 1 controlling the proportion of space
taken by each bar.}

\item{drawBorders}{logical; if \code{TRUE} a border is drawn around each bar.}

\item{main}{title for the plot}

\item{main.line}{the number of lines into the top margin at which the plot
title will be drawn.}

\item{na.col}{color of missing values to plot.}

\item{yaxt}{logical; If \code{TRUE}, the rownames of \code{heights} will be 
rendered to the left of the bars.}

\item{plotModuleNames}{logical; if \code{TRUE} the names of the modules are
plotted along the x axis.}

\item{yaxt.line}{the number of lines into the margin at which the y axis 
labels will be drawn.}

\item{maxt.line}{the number of lines into the margin at which the module 
labels will be drawn.}

\item{xaxt.line}{the number of lines into the margin at which the x axis
labels will be drawn}

\item{xaxt.tck}{the size of the x-axis ticks.}

\item{xlab}{x axis label}

\item{xlab.line}{the number of lines into the bottom margin at which the 
x axis label will be drawn.}

\item{cex.modules}{relative size of module names.}

\item{lwd}{line width for borders.}

\item{dryRun}{logical; if \code{TRUE} only the axes and borders will be 
drawn.}
}
\description{
Plot multiple horizontal bar plots
}

