% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkProperties.R
\name{netPropsInternal}
\alias{netPropsInternal}
\title{Internal function for calculating 'networkProperties'}
\usage{
netPropsInternal(network, data, moduleAssignments, modules, discovery, test,
  nDatasets, datasetNames, verbose, loadedIdx, dataLoaded, networkLoaded,
  keepLast = FALSE)
}
\arguments{
\item{network}{\code{'network'} after processing by \code{'processInput'}.}

\item{data}{\code{'data'} after processing by \code{'processInput'}.}

\item{moduleAssignments}{\code{'moduleAssignments'} after processing by
\code{'processInput'}.}

\item{modules}{\code{'modules'} after processing by \code{'processInput'}.}

\item{discovery}{\code{'discovery'} after processing by
\code{'processInput'}.}

\item{test}{\code{'test'} after processing by \code{'processInput'}.}

\item{nDatasets}{a vector containing the total number of input datasets, 
returned by \code{'processInput'}.}

\item{datasetNames}{a vector of dataset names returned by
\code{'processInput'}.}

\item{verbose}{logical; should progress be reported? Default is \code{TRUE}.}

\item{loadedIdx}{index of the currently loaded dataset.}

\item{dataLoaded}{reference to currently loaded data matrix (may be NULL).}

\item{networkLoaded}{reference to currently loaded network matrix.}

\item{keepLast}{logical; should the dataset processed last be kept in RAM?}
}
\value{
A list of network properties, and also the currently loaded dataset if
 keepLast is TRUE.
}
\description{
This function is used by several package functions. It assumes that all user
input has been processed already by \code{\link{processInput}}. This allows
for function-specific checking (i.e. failing early where the \code{'data'} is
required), while avoiding duplication of time-intensive checks 
(e.g. \code{\link{CheckFinite}}).
}

