% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkProperties.R
\name{filterInternalProps}
\alias{filterInternalProps}
\title{Filter structure returned by 'netPropsInternal' to specified test datasets}
\usage{
filterInternalProps(props, test, discovery, modules = NULL)
}
\arguments{
\item{props}{nested list returned by \code{\link{netPropsInternal}}.}

\item{test}{a vector of datasets to filter to.}

\item{discovery}{a vector containing a single discovery dataset specified in
the parent plot function.}

\item{modules}{a vector of modules from the specified \code{discovery} 
dataset to filter to. If \code{NULL}, then all modules are kept.}
}
\value{
a nested list structure identical to that returned by 
 \code{'netPropsInternal'}, but where only the entries for test datasets
 specified by the \code{test} argument and modules specified by the 
 \code{modules} argument contain non-\code{NULL} entries.
}
\description{
Used in the plot functions to filter the structure to the 
\code{'orderNodesBy'} and \code{'orderSamplesBy'} \emph{test} datasets.
}

