% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\docType{methods}
\name{randomXYcor}
\alias{randomXYcor}
\alias{randomXYcor,worldNLR,numeric-method}
\title{Random \code{turtles} coordinates}
\usage{
randomXYcor(world, n)

\S4method{randomXYcor}{worldNLR,numeric}(world, n)
}
\arguments{
\item{world}{\code{WorldMatrix} or \code{worldArray} object.}

\item{n}{Integer.}
}
\value{
Matrix (\code{ncol} = 2, \code{nrow} = \code{n}) with the first column \code{xcor} and the second
        column \code{ycor}.
}
\description{
Report \code{n} random \code{xcor} and \code{ycor} coordinates within the \code{world}'s extent.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4,
                          data = runif(25))
t1 <- createTurtles(n = 10, coords = randomXYcor(world = w1, n = 10))
plot(w1)
points(t1, col = of(agents = t1, var = "color"), pch = 16)


}
\author{
Sarah Bauduin
}
