% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{est_cfarh}
\alias{est_cfarh}
\title{Estimation of a CFAR Process with Heteroscedasticity and Irregualar Observation Locations}
\usage{
est_cfarh(f, weight, p = 2, grid = 1000, df_b = 5, num_obs = NULL,
  x_pos = NULL)
}
\arguments{
\item{f}{the functional time series.}

\item{weight}{the covariance functions of noise process.}

\item{p}{CFAR order.}

\item{grid}{the number of gird points used to construct the functional time series and noise process. Default is 1000.}

\item{df_b}{the degrees of freedom for natural cubic splines. Default is 10.}

\item{num_obs}{the numbers of observations. It is a t-by-1 vector, where t is the length of time.}

\item{x_pos}{the observation location matrix. If the locations are regular, it is a t-by-(n+1) matrix with all entries 1/n.}
}
\value{
The function returns a list with components:
\item{phi_coef}{estimated spline coefficients for convolutional function(s).}
\item{phi_func}{estimated convolutional function(s).}
\item{rho}{estimated rho for O-U process (noise process).}
\item{sigma}{estimated sigma for O-U process (noise process).}
}
\description{
Estimation of a CFAR process with heteroscedasticity and irregualar observation locations.
}
\references{
Liu, X., Xiao, H., and Chen, R. (2016) Convolutional autoregressive models for functional time series. \emph{Journal of Econometrics}, 194, 263-282.
}
