% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TNPMLE_R.R
\name{TNPMLE}
\alias{TNPMLE}
\title{Non-Parametric Maximum-Likelihood Estimation for Cohort Samplings with Time Matching under Cox's Regression Model}
\usage{
TNPMLE(data, iteration1, iteration2, converge)
}
\arguments{
\item{data}{The \eqn{N \times P} matrix of data. There are \eqn{N} individuals in matrix, with one individual in each row. The \eqn{P} columns orderly included the observable times which are time-to-event or censoring times and without ties at the event times, the status is a binary variable with 1 indicating the event has occured and 0 indicating (right) censoring, and the (\eqn{P-2}) covariates which only observed for some individuals. Note that the covariate of those unobserved individuals are denoted by \eqn{-9}, not missing value (NA) and the observed covariates values are not the same as \eqn{-9}.}

\item{iteration1}{The number of iteration for computing NPMLEs.}

\item{iteration2}{The number of iteration for computing profile likelihoods which are used to estimate asymptotic variance.}

\item{converge}{The parameter influence the convergence of the algorithm, if the sup-norm of \eqn{\left(\hat{\beta}_{(k)}-\hat{\beta}_{(k-1)}\right)} is smaller than the thresholding value, we then declare the estimates are converge, stop computing estimates, otherwise the number of iteration for computing estimates is the \code{iteration1} term.}
}
\value{
Returns a list with components

\item{num}{The numbers of case and observed subjects.}

\item{iloop}{The final number of iteration for computing NPMLEs.}

\item{diff}{The sup-norm distance between the last two iterations of the estimates of the relative risk coefficients.}

\item{likelihood}{The log likelihood value of NPMLEs.}

\item{npmle}{The estimated regression coefficients with their corresponding estimated standard errors and p-values.}

\item{Lnpmle}{The estimated cumulative baseline hazards function.}

\item{Pnpmle}{The empirical distribution of covariates which are missing for unobserved subjects.}

\item{elements}{A list which is used to plot cumulative baseline hazards function and baseline survival function. The \eqn{n \times 3} matrix of data, \eqn{n} is the total number of case and the \eqn{3} columns orderly included the order observed time of case, the estimated cumulative baseline hazards function and estimated baseline survival function.}

\item{Adata}{Arranging original data to let our analysis performed conveniently. There are three steps for this arrangement, the 1st step divides original data into observed and unobserved groups, then put them on top and bottom, respectively; the 2nd step divides the observed data of 1st step into case and control groups; the final step order the case data of 2nd step by observed time from low to high.}
}
\description{
The function utilizes a self-consistency iterative algorithm to calculate NPMLEs for cohort samplings with time matching under Cox's regression model. In addition to compute NPMLEs, it can also estimate asymptotic varance, as described in Wang et al. (2019). The Cox's regression model is \deqn{\lambda(t|z)=\lambda_{0}(t)\exp(z^T\beta).}
}
\note{
The missing value (NA) in the DATA is not allowed in this version.
}
\examples{
set.seed(100)
library(splines)
library(survival)
library(MASS)
beta=c(1,0)
lambda=0.3
cohort=100
covariate=2+length(beta)
z=matrix(rnorm(cohort*length(beta)),nrow=cohort)
rate=1/(runif(cohort,1,3)*exp(z\%*\%beta))
c=rexp(cohort,rate)
u=-log(runif(cohort,0,1))/(lambda*exp(z\%*\%beta))
time=apply(cbind(u,c),1,min)
status=(u<=c)+0
casenum=sum(status)
odata=cbind(time,status,z)
odata=data.frame(odata)
a=order(status)
data=matrix(0,cohort,covariate)
data=data.frame(data)
for (i in 1:cohort){
data[i,]=odata[a[cohort-i+1],]
}
ncc=matrix(0,cohort,covariate)
ncc=data.frame(data)
aa=order(data[1:casenum,1])
for (i in 1:casenum){
ncc[i,]=data[aa[i],]
}
control=1
q=matrix(0,casenum,control)
for (i in 1:casenum){
k=c(1:cohort)
k=k[-(1:i)]
sumsc=sum(ncc[i,1]<ncc[,1][(i+1):cohort])
if (sumsc==0) {
			q[i,]=c(1)
} else {
			q[i,]=sample(k[ncc[i,1]<ncc[,1][(i+1):cohort]],control)
}
}
cacon=c(q,1:casenum)
k=c(1:cohort)
owf=k[-cacon]
wt=k[-owf]
owt=k[-wt]
ncct=matrix(0,cohort,covariate)
ncct=data.frame(ncct)
for (i in 1:length(wt)){
ncct[i,]=ncc[wt[i],]
}
for (i in 1:length(owt)){
ncct[length(wt)+i,]=ncc[owt[i],]
}
d=length(wt)+1
ncct[d:cohort,3:covariate]=-9
TNPMLEtest=TNPMLE(data=ncct,iteration1=100,iteration2=30,converge=0)
}
\references{
Wang JH, Pan CH, Chang IS*, and Hsiung CA (2019) Penalized full likelihood approach to variable selection for Cox's regression model under nested case-control sampling. published in Lifetime Data Analysis <doi:10.1007/s10985-019-09475-z>.
}
\seealso{
See \code{\link{TPNPMLE}}.
}
