% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partial_Moments.R
\name{UPM}
\alias{UPM}
\title{Upper Partial Moment}
\usage{
UPM(degree, target, variable)
}
\arguments{
\item{degree}{integer; \code{(degree = 0)} is frequency, \code{(degree = 1)} is area.}

\item{target}{numeric; Typically set to mean, but does not have to be. (Vectorized)}

\item{variable}{a numeric vector.}
}
\value{
UPM of variable
}
\description{
This function generates a univariate upper partial moment for any degree or target.
}
\examples{
set.seed(123)
x <- rnorm(100)
UPM(0, mean(x), x)
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{https://www.amazon.com/dp/1490523995}
}
\author{
Fred Viole, OVVO Financial Systems
}
