% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMsim_default.R
\name{NMsim_default}
\alias{NMsim_default}
\title{Transform an estimated Nonmem model into a simulation control
stream}
\usage{
NMsim_default(
  file.sim,
  file.mod,
  data.sim,
  nsims = 1,
  replace.sim = TRUE,
  return.text = FALSE
)
}
\arguments{
\item{file.sim}{See \code{?NMsim}.}

\item{file.mod}{See \code{?NMsim}.}

\item{data.sim}{See \code{?NMsim}.}

\item{nsims}{Number of replications wanted. The default is 1. If
greater, multiple control streams will be generated.}

\item{replace.sim}{If there is a $SIMULATION section in the
contents of file.sim, should it be replaced? Default is
yes. See the \code{list.section} argument to \code{NMsim} for
how to provide custom contents to sections with \code{NMsim}
instead of editing the control streams beforehand.}

\item{return.text}{If TRUE, just the text will be returned, and
resulting control stream is not written to file.}
}
\value{
Character vector of simulation control stream paths
}
\description{
The default behaviour of \code{NMsim}. Replaces any $ESTIMATION
and $COVARIANCE sections by a $SIMULATION section.
}
