% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMreadSim.R
\name{NMreadSim}
\alias{NMreadSim}
\title{Read simulation results based on NMsim's track of model runs}
\usage{
NMreadSim(x, check.time = FALSE, as.fun)
}
\arguments{
\item{x}{Path to the simulation-specific rds file generated by
NMsim, typically called `NMsim_paths.rds`. Or a table of
simulation runs as returned by NMsim when `wait=FALSE`.}

\item{check.time}{If found, check whether `fst` file modification
time is newer than `rds` file. The `fst` is generated based on
information in `rds`, but notice that some systems don't
preserve the file modification times. Becasue of that,
`check.time` is `FALSE` by default.}

\item{as.fun}{The default is to return data as a data.frame. Pass
a function (say `tibble::as_tibble`) in as.fun to convert to
something else. If data.tables are wanted, use
as.fun="data.table". The default can be configured using
NMdataConf.}
}
\value{
A data set of class defined by as.fun
}
\description{
Read simulation results based on NMsim's track of model runs
}
