% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_nm.R
\name{temp_files}
\alias{temp_files}
\alias{ls_tempfiles}
\alias{clean_run}
\alias{clean_tempfiles}
\title{Remove temporary NONMEM files}
\usage{
ls_tempfiles(
  object = ".",
  output_loc = c("run_dir", "base"),
  run_files = NA_character_,
  include_slurm_files = TRUE,
  ctl_extension = "mod",
  include_psn_exports = FALSE
)

clean_run(m, output_loc = c("run_dir", "base"), include_slurm_files = TRUE)

clean_tempfiles(
  object = ".",
  output_loc = c("run_dir", "base"),
  include_slurm_files = TRUE
)
}
\arguments{
\item{object}{Either an nm object or path to project (default = \code{"."}).  If a
path is specified, the function will look for all runs in the directory
(including subdirectories).}

\item{output_loc}{Optional character for locating files. Either \code{"run_dir"}
(default) for PsN execution or \code{"base"} for "nmfe" execution.}

\item{run_files}{Optional character vector.  Search amongst only these files
instead.  Default value \code{NA} searches based on \code{object}.}

\item{include_slurm_files}{Logical (default = \code{TRUE}). Include files
generated by Slurm.}

\item{ctl_extension}{Character. Extension of control file (default = \code{"mod"})}

\item{include_psn_exports}{Logical (default = \code{FALSE}). Considers files that
PsN exports to the \code{run_in} directory as temporary}

\item{m}{An nm object}
}
\value{
A \code{character} vector of temporary file paths
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

NONMEM produces a lot of temporary files which can add up to a lot of disk
space.  One strategy to remove this is to use the \code{clean} option in the PsN
command.  However, this can automatically remove files as soon as the run
finishes that may be useful for debugging.  \code{ls_tempfiles()} allows you to
list the paths of all temporary files, for a single run or for all runs for
inspection and deletion. \code{clean_tempfiles()} is a wrapper function that runs
\code{ls_tempfiles()} and deletes everything returned.  For safety is limited to
only deleting files associated with \code{nm} objects though.
}
\details{
Setting \code{include_psn_exports = TRUE} will break 'Pirana' and 'xpose'
capability as these software use exported files.
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1",
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))

ls_tempfiles(m1) ## if no files, will be empty

m1 \%>\%
  ls_tempfiles() \%>\%
  unlink() ## delete all m1 temp files

## above line is equivalent to:
clean_tempfiles(m1)

ls_tempfiles() ## display all temp files in analysis project

ls_tempfiles() \%>\% unlink() ## remove all temp files in analysis project

}
