% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_funs.R
\name{block-omega-sigma}
\alias{block-omega-sigma}
\alias{block}
\alias{unblock}
\title{Create or remove $OMEGA/$SIGMA BLOCKs}
\usage{
block(iomega, eta_numbers = NA, diag_init = 0.01)

unblock(iomega, eta_numbers)
}
\arguments{
\item{iomega}{A \code{tibble} output from \code{\link[=init_omega]{init_omega()}} or \code{\link[=init_sigma]{init_sigma()}}.}

\item{eta_numbers}{Numeric vector.  ETA numbers to put into a block or
unblock for \code{block()} and \code{unblock()}, respectively. Must be contiguous.}

\item{diag_init}{Numeric. Default value for off diagonal elements.}
}
\value{
An nm object with modified \code{ctl_contents} field.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Manipulate $OMEGA (and $SIGMA) BLOCKs to introduce or remove correlations.
}
\examples{


# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))

io <- m1 \%>\% init_omega()
io <- io \%>\% block(c(2, 3))
m1 <- m1 \%>\% init_omega(io)
m1 \%>\% dollar("OMEGA") ## to display $OMEGA


# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))

## first create a block
io <- m1 \%>\% init_omega()
io <- io \%>\% block(c(2, 3))
m1 <- m1 \%>\% init_omega(io)
m1 \%>\% dollar("OMEGA") ## to display $OMEGA

## now unblock
io <- io \%>\% unblock(c(2, 3))
m1 <- m1 \%>\% init_omega(io)
m1 \%>\% dollar("OMEGA") ## to display $OMEGA

}
\seealso{
\code{\link[=init_theta]{init_theta()}}, \code{\link[=init_omega]{init_omega()}}, \code{\link[=init_sigma]{init_sigma()}}
}
