% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addTAPD.R
\name{addTAPD}
\alias{addTAPD}
\title{Add time since previous dose to data, time of previous dose, most
recent dose amount, cumulative number of doses, and cumulative
dose amount.}
\usage{
addTAPD(
  data,
  col.time = "TIME",
  col.evid = "EVID",
  col.amt = "AMT",
  col.tpdos = "TPDOS",
  col.tapd = "TAPD",
  col.ndoses = "NDOSES",
  col.pdosamt = "PDOSAMT",
  col.doscuma = "DOSCUMA",
  prefix.cols,
  suffix.cols,
  subset.dos,
  subset.is.complete,
  order.evid = c(3, 0, 2, 4, 1),
  by = "ID",
  SDOS = 1,
  as.fun
)
}
\arguments{
\item{data}{The data set to add the variables to.}

\item{col.time}{Name of time column (created by addTAPD). Default
it TIME.}

\item{col.evid}{The name of the event ID column. This must exist
in data. Default is EVID.}

\item{col.amt}{col.evid The name of the dose amount column. This
must exist in data. Default is AMT.}

\item{col.tpdos}{Name of the time of previous dose column (created
by addTAPD). Default is TPDOS. Set to NULL to not create this
column.}

\item{col.tapd}{Name of the time of previous dose column (created
by addTAPD). Default is TAPD. Set to NULL to not create this
column.}

\item{col.ndoses}{The name of the column (created by addTAPD) that
holds the cumulative number of doses administered to the
subject. Set to NULL to not create this column.}

\item{col.pdosamt}{The name of the column to be created holding
the previous dose amount. Set to NULL to not create this
column.}

\item{col.doscuma}{The name of the column to be created holding
the cumulative dose amount. Set to NULL to not create this
column.}

\item{prefix.cols}{String to be prepended to all generated column
names, that is each of col.tpdos, col.tapd, col.ndoses,
col.pdosamt, col.doscuma that are not NULL.}

\item{suffix.cols}{String to be appended to all generated column
names, that is each of col.tpdos, col.tapd, col.ndoses,
col.pdosamt, col.doscuma that are not NULL.}

\item{subset.dos}{A string that will be evaluated as a custom
expression to identify relevant events. See subset.is.complete
as well.}

\item{subset.is.complete}{Only used in combination with
non-missing subset.dos. By default, subset.dos is used in
addition to the impact of col.evid (must be 1 or 4) and col.amt (greater than zero). If
subset.is.complete=TRUE, subset.dos is used alone, and
col.evid and col.amt are completely ignored. This is typically
useful if the events are not doses but other events that are
not expressed as a typical dose combination of EVID and AMT
columns.}

\item{order.evid}{Order of events. This will only matter if there
are simultaneous events of different event types within
subjects. Typically if using nominal time, it may be important
to specify whether samples at dosing times are pre-dose
samples. The default is c(3,0,4,1,2) - i.e. samples and
simulations are pre-dose. See details.}

\item{by}{Columns to do calculations within. Default is ID.}

\item{SDOS}{Scaling value for columns related to dose amount,
relative to AMT values. col.pdosamt and col.doscuma are
affected and will be derived as AMT/SDOSE.}

\item{as.fun}{The default is to return data as a data.frame. Pass
a function (say tibble::as_tibble) in as.fun to convert to
something else. If data.tables are wanted, use
as.fun="data.table". The default can be configured using
NMdataConf.}
}
\value{
A data.frame with additional columns
}
\description{
For now, doses have to be in data as EVID=1 and/or EVID=4
records. They can be in the format of one row per dose or repeated
dosing notation using ADDL and II.
}
\details{
addTAPD does not require the data to be ordered, and it
    will not order it. This means you can run addTAPD before
    ordering data (which may be one of the final steps) in data
    set preparation. The argument called order.evid is important
    because of this. If a dosing event and a sample occur at the
    same time, when which dose was the previous for that sample?
    Default is to assume the sample is a pre-dose sample, and
    hence output will be calculated in relation to the dose
    before. If no dose event is found before, NA's will be
    assigned.
}
\seealso{
Other DataCreate: 
\code{\link{NMorderColumns}()},
\code{\link{NMstamp}()},
\code{\link{NMwriteData}()},
\code{\link{findCovs}()},
\code{\link{findVars}()},
\code{\link{flagsAssign}()},
\code{\link{flagsCount}()},
\code{\link{mergeCheck}()},
\code{\link{tmpcol}()}
}
\concept{DataCreate}
