% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPC_EMP.R
\name{MPC_EMP}
\alias{MPC_EMP}
\title{MPC_EMP}
\usage{
MPC_EMP(specdat, withBC = TRUE)
}
\arguments{
\item{specdat}{A complex number vector of observed frequency domain data.}

\item{withBC}{A logical parameter that enables/disables baseline correction after baseline correction}
}
\value{
A numeric vector of phase corrected absorption spectrum
}
\description{
Multiple single linear models based on entropy minimization with negative peak penalty.
}
\details{
This function is used to process phase error correction through multiple single linear models with entropy minimization with negative peak penalty, followed by polynomial baseline correction when necessary.
}
\examples{
data("fdat")
mpc_emp_phased1 <- MPC_EMP(fdat$frequency_domain)
}
\references{
Binczyk F, Tarnawski R, Polanska J (2015) Strategies for optimizing the phase correction algorithms in Nuclear Magnetic Resonance spectroscopy. Biomed Eng Online 14 Suppl 2:S5.

de Brouwer, H. (2009). Evaluation of algorithms for automated phase correction of NMR spectra. J Magn Reson, 201, 230-238.

Liland KH, Almøy T, Mevik B (2010), Optimal Choice of Baseline Correction for Multivariate Calibration of Spectra, Applied Spectroscopy 64, pp. 1007-1016.
}
\author{
Aixiang Jiang
}
\concept{phase correction}
