% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_group.R
\name{as_control_group}
\alias{as_control_group}
\title{Convert list of nipt samples to nipt control group}
\usage{
as_control_group(nipt_samples, control_group_type = generic_control_group)
}
\arguments{
\item{nipt_samples}{List of nipt_sample objects to be combined to a control
group}

\item{control_group_type}{Control group type, either 'generic control group' 
or 'fitted to sample'. Leave this argument blank}
}
\value{
NIPTControlGroup object
}
\description{
Convert list of nipt samples to nipt control group
}
\details{
This function returns an S3 object of class nipt_control_group. It is a list 
with 3 items:

\itemize{
\item List \strong{Samples} nipt_sample objects in the control group
\item Character \strong{Correction_status} Correction_status(es) in the 
control group
\item Character \strong{Samplenames} The sample names of samples present 
in the control group
}
Read count strategy should be uniform in all samples in a control group object;
meaning samples where forward and reverse reads are counted separately 
cannot be in the same control group object as samples where forward and reverse
reads are counted together.

A control group object with duplicate samples or samples with different 
correction statusses is possible but not recommended and will generate a 
warning message.
}
\examples{
\dontrun{
##Retrieve filenames
bam_filepaths <- list.files(path = "/Path/to/bamfiles/", pattern = ".bam", full.names = T)
##Load files and convert to control group
control_group  <- as_control_group(nipt_samples = lapply(X = bam_filepaths, bin_bam_sample, 
                                                         do_sort = F, separate_strands = FALSE))
##Save control group for later
saveRDS(object = control_group, file = "/Path/to/directory/control_group.rds")
}
}

